<?php
/*--------------------------------------------------------------------
 ShippingLink.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/
namespace Gambio\Shop\SellingUnit\Unit\ValueObjects;

/**
 * Class ShippingLink
 * @package Gambio\Shop\SellingUnit\Unit\ValueObjects
 */
class ShippingLink
{
    /**
     * @var string
     */
    protected $link;
    
    
    /**
     * ShippingLink constructor.
     *
     * @param string $link
     */
    public function __construct(string $link)
    {
        $this->link = $link;
    }
    
    
    /**
     * @return string
     */
    public function value(): string
    {
        return $this->link;
    }
}